/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

float t = iGlobalTime;

float modulus1(vec2 rp) {
   rp.x -= 0.5 * t;
   vec2 m = mod(rp, 4.0) - vec2(2.0);
   return abs(m.x * m.y);
}

float modulus2(vec2 rp) {
   rp.x -= 0.2 * t;
   vec2 m = mod(rp, 8.8) - vec2(4.4);
   return abs(m.x * m.y);
}

float modulus3(vec2 rp) {
   rp.x += 0.7 * t;
   vec2 m = mod(rp, 2.4) - vec2(1.2);
   return abs(m.x * m.y);
}

// Standard hue rotation formula... compacted down a bit.
vec3 rotHue(vec3 p, float a){

   vec2 cs = sin(vec2(1.570796, 0) + a);

   mat3 hr =
      mat3(0.299, 0.587, 0.114, 0.299, 0.587, 0.114, 0.299, 0.587, 0.114)
    + mat3(0.701,-0.587,-0.114,-0.299, 0.413,-0.114,-0.300,-0.588, 0.886) * cs.x
    + mat3(0.168, 0.330,-0.497,-0.328, 0.035, 0.292, 1.250,-1.050,-0.203) * cs.y;

    return clamp(p*hr, 0., 1.);
}

vec4 colourCircle(vec2 p) {

   vec4 pc = vec4(0.0);

   float zoom = sin(t * 0.05) * 5.0;
   float trap1 = 1e20;
   float trap2 = 1e20;
   float trap3 = 1e20;

   vec2 z = abs(p) * zoom / dot(p, p);

   for(int i = 0; i < 256; i++) {

       z = abs(p) * zoom / dot(p, p);

       trap1 = min(trap1, modulus1(z));
       trap2 = min(trap2, modulus2(z));
       trap3 = min(trap3, modulus3(z));
   }

    //colour model stolen from IQ fractals
    float c1 = pow(clamp(0.4 * trap1, 0.0, 1.0 ), 0.05);
    float c2 = pow(clamp(0.4 * trap2, 0.0, 1.0 ), 0.5);
    float c3 = pow(clamp(0.4 * trap3, 0.0, 1.0 ), 0.05);

    // Hue rotation
    vec4 mc = vec4(1.0, 0.0, 0.0, 1.0);
    mc.xyz = rotHue(mc.xyz, mod(t / 16., 6.283));

    vec4 col1 = vec4(0.5 + 0.5 * sin(4.1 + 2.0 * c1 + vec3(0.1, 0.0, 0.0)), .5);
    vec4 col2 = vec4(0.5 + 0.5 * sin(4.1 + 2.0 * c2 + mc.xyz), .5);
    vec4 col3 = vec4(0.5 + 0.5 * sin(4.1 + 2.0 * c3 + vec3(0.0, 0.0, 1.0)), .5);

    pc = col1 * 2.0;
    pc = mix(pc, col2 * 2.0, 0.3);
    pc = mix(pc, col3 * 2.0, 0.3);

    return 0.8 - pc;
}

void mainImage(out vec4 fragColor, in vec2 fragCoord) {

    vec2 uv = fragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;

    fragColor = colourCircle(uv);
}

void main ( void )
{
   mainImage ( gl_FragColor, gl_FragCoord.xy );
   gl_FragColor.a = 1.0;
}
